using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Borland.Eco.Handles;
using Borland.Eco.Windows.Forms;
using Borland.Eco.WinForm;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;

namespace LazyFetchAlert
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private Borland.Eco.Handles.ReferenceHandle rhRoot;
		private Borland.Eco.WinForm.EcoActionExtender EcoGlobalActions;
		private Borland.Eco.WinForm.EcoDragDropExtender EcoModelAwareDragDrop;
		private Borland.Eco.WinForm.EcoAutoFormExtender EcoAutoForms;
		private Borland.Eco.WinForm.EcoListActionExtender EcoListActions;
		private LazyFetchAlertEcoSpace ecoSpace;
		private System.Windows.Forms.Button btnGenSchema;
		private System.Windows.Forms.Button btnActivate;
		private System.Windows.Forms.Button btnUpdateDB;
		private System.Windows.Forms.TextBox tbxFetchLog;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button btnNormalForm;
		private System.Windows.Forms.Button btnOptimizedForm;
		public LazyFetchAlertEcoSpace EcoSpace
		{
			get { 
				if (ecoSpace == null)
				{
					ecoSpace = new LazyFetchAlertEcoSpace();
					rhRoot.EcoSpace = ecoSpace;
				}
				return ecoSpace;
			}
		}

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			// The line below will automatically activate the ECO Space.
			// Remove the line if you need to perform any initialization
			// before activating the ECO Space
			EcoSpace.Active = false;
			EcoSpace.m_FetchDetector.OnSingleFetch += new FetchAlertDelegate(WriteToLog);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			this.EcoListActions = new Borland.Eco.WinForm.EcoListActionExtender();
			this.EcoModelAwareDragDrop = new Borland.Eco.WinForm.EcoDragDropExtender();
			this.EcoGlobalActions = new Borland.Eco.WinForm.EcoActionExtender();
			this.btnGenSchema = new System.Windows.Forms.Button();
			this.btnActivate = new System.Windows.Forms.Button();
			this.btnUpdateDB = new System.Windows.Forms.Button();
			this.EcoAutoForms = new Borland.Eco.WinForm.EcoAutoFormExtender();
			this.tbxFetchLog = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.btnNormalForm = new System.Windows.Forms.Button();
			this.btnOptimizedForm = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// rhRoot
			// 
			this.rhRoot.EcoSpaceType = typeof(LazyFetchAlert.LazyFetchAlertEcoSpace);
			// 
			// EcoGlobalActions
			// 
			this.EcoGlobalActions.RootHandle = this.rhRoot;
			// 
			// btnGenSchema
			// 
			this.EcoGlobalActions.SetEcoAction(this.btnGenSchema, Borland.Eco.WinForm.EcoAction.CreateSchema);
			this.btnGenSchema.Location = new System.Drawing.Point(24, 16);
			this.btnGenSchema.Name = "btnGenSchema";
			this.btnGenSchema.Size = new System.Drawing.Size(96, 23);
			this.btnGenSchema.TabIndex = 0;
			this.btnGenSchema.Text = "Create Schema";
			// 
			// btnActivate
			// 
			this.EcoGlobalActions.SetEcoAction(this.btnActivate, Borland.Eco.WinForm.EcoAction.ToggleActive);
			this.btnActivate.Location = new System.Drawing.Point(24, 48);
			this.btnActivate.Name = "btnActivate";
			this.btnActivate.Size = new System.Drawing.Size(96, 23);
			this.btnActivate.TabIndex = 1;
			this.btnActivate.Text = "Activate";
			// 
			// btnUpdateDB
			// 
			this.EcoGlobalActions.SetEcoAction(this.btnUpdateDB, Borland.Eco.WinForm.EcoAction.UpdateDatabase);
			this.btnUpdateDB.Location = new System.Drawing.Point(24, 80);
			this.btnUpdateDB.Name = "btnUpdateDB";
			this.btnUpdateDB.Size = new System.Drawing.Size(96, 23);
			this.btnUpdateDB.TabIndex = 2;
			this.btnUpdateDB.Text = "Update DB";
			// 
			// tbxFetchLog
			// 
			this.tbxFetchLog.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.tbxFetchLog.Location = new System.Drawing.Point(8, 136);
			this.tbxFetchLog.Multiline = true;
			this.tbxFetchLog.Name = "tbxFetchLog";
			this.tbxFetchLog.ReadOnly = true;
			this.tbxFetchLog.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.tbxFetchLog.Size = new System.Drawing.Size(272, 152);
			this.tbxFetchLog.TabIndex = 3;
			this.tbxFetchLog.Text = "";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 112);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(32, 23);
			this.label1.TabIndex = 4;
			this.label1.Text = "Log:";
			// 
			// btnNormalForm
			// 
			this.btnNormalForm.Location = new System.Drawing.Point(152, 32);
			this.btnNormalForm.Name = "btnNormalForm";
			this.btnNormalForm.Size = new System.Drawing.Size(120, 23);
			this.btnNormalForm.TabIndex = 5;
			this.btnNormalForm.Text = "Open normal form";
			this.btnNormalForm.Click += new System.EventHandler(this.btnNormalForm_Click);
			// 
			// btnOptimizedForm
			// 
			this.btnOptimizedForm.Location = new System.Drawing.Point(152, 64);
			this.btnOptimizedForm.Name = "btnOptimizedForm";
			this.btnOptimizedForm.Size = new System.Drawing.Size(120, 23);
			this.btnOptimizedForm.TabIndex = 6;
			this.btnOptimizedForm.Text = "Open optimized form";
			this.btnOptimizedForm.Click += new System.EventHandler(this.btnOptimizedForm_Click);
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 293);
			this.Controls.Add(this.btnOptimizedForm);
			this.Controls.Add(this.btnNormalForm);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.tbxFetchLog);
			this.Controls.Add(this.btnUpdateDB);
			this.Controls.Add(this.btnActivate);
			this.Controls.Add(this.btnGenSchema);
			this.Name = "WinForm";
			this.Text = "WinForm";
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			WinFormDequeuer.Active = true;
			Application.Run(new WinForm());
		}

		private void WriteToLog(string message)
		{
			tbxFetchLog.AppendText(message + "\r\n");
		}

		private void btnNormalForm_Click(object sender, System.EventArgs e)
		{
			new EcoWinForm(EcoSpace, false).Show();
		}

		private void btnOptimizedForm_Click(object sender, System.EventArgs e)
		{
			new EcoWinForm(EcoSpace, true).Show();
		}
		

	}
}
